unit uEffect;
interface
uses
Omega,Omega3d,uRes,uModelEngine;

Type
TFire = class(CModel)
ang    : integer;
alpha2 : integer;
color1,color2 : integer;
Procedure Process; override;
procedure Draw; override;
Constructor Create( aX, aY,aZ:single;aang:integer;aColor1,acolor2:integer);
end;

Type
TBoom = class(CModel)
alpha2        : integer;
color1,color2 : integer;
ang           : integer;
Procedure Process; override;
procedure Draw; override;
Constructor Create( aX, aY,aZ:single;aang:integer;aColor1,acolor2:integer);
end;

type
TVector = record
x,y :single;
end;


Type
TStar = record //  
Point    : array[1..40] of Tvector; //  
y        : single; //     
size     : integer; //
col      : array[1..40] of integer; // 
Procedure Process;
procedure Draw;
end;

Type
TAsteroid = class(CModel)
Speed   : single; // 
Vrx,Vrz : integer; // 
Procedure Process; override;
procedure Draw; override;
Constructor Create( aX, aY,az:single);
end;

var
arStar:array[1..2] of tStar;

procedure CreateStar;
Procedure StarDraw;
Procedure StarProcess;

procedure Create_Fire(x,y,z:single;count:integer;Color1,color2:integer);
procedure Create_Boom(x,y,z:single;count:integer;Color1,color2:integer);
implementation
uses
uGame;
//==================================================//
//                                                  //
//=============================================//
//                                                  //
//==================================================//
procedure Create_Boom(x,y,z:single;count:integer;Color1,color2:integer);
var
i:integer;
begin
for i:=1 to m_round(360/count) do
NewObj(Tboom.Create(x,y,z,i,color1,color2 ));
end;

Constructor TBoom.Create( aX, aY,aZ:single;aang:integer;aColor1,acolor2:integer);
begin
 inherited Create;
 x        := ax;
 y        := ay;
 z        := az;
 Texture  := spark;
 otr      := true;
 NModel   := false;
 fx       := of_texturing or of_blend;
 alpha2   := 255;
 color1   := acolor1;
 color2   := acolor2;
 ang      := aang;
 end;

 Procedure TBoom.Process;
 begin
 inherited;

 //        5   
 alpha:=alpha-(random(15)+10);
 alpha2:=alpha2-45;

 if alpha2<=0 then alpha2:=0;

 if alpha<=25 then kill:=true;

 //  ""  
  x:=x + m_cos( m_round(ang))*0.1;
 y:=y + m_sin( m_round(ang))*0.1;

 x:=x + ((random(10)-5)/100);
 y:=y - (random(10)/100);


 
 end;

procedure TBoom.Draw;
Begin
inherited;
FX_SetBlendMode(FX_BLEND_ADD);
Obj_begin(OF_blend or OF_TEXTURING );
Obj_SetColor(color1,round((80*alpha)/255));
Obj_BindTexture(Texture);
SBillBoard_Draw(x,y,z,0.15,0.15,0.15);
Obj_end;
FX_SetBlendMode(FX_BLEND_NORMAL);

if alpha2 >0 then
begin
FX_SetBlendMode(FX_BLEND_ADD);
Obj_begin(OF_blend or OF_TEXTURING );
Obj_SetColor(color2,alpha2);
Obj_BindTexture(Texture);
SBillBoard_Draw(x,y,z,0.15,0.15,0.15);
Obj_end;
FX_SetBlendMode(FX_BLEND_NORMAL);
end;
End;

//==================================================//
//                                                  //
//=============================================//
//                                                  //
//==================================================//
procedure Create_Fire(x,y,z:single;count:integer;Color1,color2:integer);
var
i:integer;
begin
if count=0 then
NewObj(TFire.Create(x,y,z,0,color1,color2 ))
else
for i:=1 to count do
NewObj(TFire.Create(x,y,z,m_round(count/2+i*6)-90-(count*4),color1,color2 ));
end;

Constructor TFire.Create( aX, aY, aZ : single;aang:integer;aColor1,aColor2:integer);
begin
 inherited Create;
 x        := ax;
 y        := ay;
 z        := az;
 Texture  := spark;
 otr      := true;
 NModel   := false;
 fx       := of_texturing or of_blend;
 ang      := aang;
 alpha2   := 255;
 color1   := acolor1;
 color2   := acolor2;
 end;

 Procedure TFire.Process;
 begin
 inherited;

 //        5   
 alpha:=alpha-(random(15)+10);
 alpha2:=alpha2-45;

 if alpha2<=0 then alpha2:=0;

 if alpha<=25 then kill:=true;

 //  ""  
 if ang = 0 then
 z:=z+0.03 else
 begin
 x:=x + m_cos( m_round(ang))*0.1;
 y:=y + m_sin( m_round(ang))*0.1;
 end;

 x:=x + ((random(10)-5)/100);
 y:=y - (random(10)/100);


 
 end;

procedure TFire.Draw;
Begin
inherited;
FX_SetBlendMode(FX_BLEND_ADD);
Obj_begin(OF_blend or OF_TEXTURING );
Obj_SetColor(color1,round((80*alpha)/255));
Obj_BindTexture(Texture);
SBillBoard_Draw(x,y,z,0.15,0.15,0.15);
Obj_end;
FX_SetBlendMode(FX_BLEND_NORMAL);

if alpha2 >0 then
begin
FX_SetBlendMode(FX_BLEND_ADD);
Obj_begin(OF_blend or OF_TEXTURING );
Obj_SetColor(color2,alpha2);
Obj_BindTexture(Texture);
SBillBoard_Draw(x,y,z,0.15,0.15,0.15);
Obj_end;
FX_SetBlendMode(FX_BLEND_NORMAL);
end;
End;


//==================================================//
//                                                  //
//=================¨===========================//
//                                                  //
//==================================================//
procedure CreateStar;
var
i:integer;
begin
arStar[1].Y:=0;
arStar[2].Y:=768;

arStar[1].size:=random(4);
arStar[2].size:=random(4);

 for i := 1 to 40 do
 begin
 //   
 arStar[1].point[i].x:=random(1024);
 arStar[1].point[i].y:=random(768);

 arStar[2].point[i].x:=random(1024);
 arStar[2].point[i].y:=random(768);

 // 
 if i<=10 then
 begin
 arStar[1].col[i]:=$00ffff;
 arStar[2].col[i]:=$00ffff;
 end;
 if (i<=20) and(i>10) then
 begin
 arStar[1].col[i]:=$0000ff;
 arStar[2].col[i]:=$0000ff;
 end;

 if (i<=30) and(i>20) then
 begin
 arStar[1].col[i]:=$ffffff;
 arStar[2].col[i]:=$ffffff;
 end;

 if (i<=40) and(i>30) then
 begin
 arStar[1].col[i]:=$ff0000;
 arStar[2].col[i]:=$ff0000;
 end;


 end;

end;

Procedure StarDraw;
var
i:integer;
begin
for i := 1 to 2 do
arStar[i].Draw;

end;

Procedure StarProcess;
var
i:integer;
begin
for i := 1 to 2 do
arStar[i].Process;
end;


 Procedure TStar.Process;
 var
 i:integer;
 begin
 inherited;
 y:=y-3;

 {
       ,
       
   
 }
 if y<-768 then
 begin
 for i := 1 to 40 do
 begin
 point[i].x:=random(1024);
 point[i].y:=random(768);
 end;
 y:=768;
 end;



 end;

procedure TStar.Draw;
var
i:integer;
Begin
inherited;
set2DMode;

for i:=1 to 40 do
begin
FX_SetColorMix( Col[i] );
Pr2D_Pixel( point[i].x, point[i].y-y, Col[i]);
//SSprite_Draw( star, point[i].x, point[i].y-y, 8, 8, 255,0, FX_DEFAULT or FX_ColorMix );
end;
End;

//==================================================//
//                                                  //
//==========================================//
//                                                  //
//==================================================//
Constructor TAsteroid.Create( aX, aY,az : single);
var
i:integer;
begin
 inherited Create;
 x:=ax;
 z:=az;
 y:=ay-z;

 Texture := AsteroidT;
 Model   := AsteroidM;
 otr:=true;
 NModel:=true;
 fx:= of_texturing;

 //   
 VrX:=random(6)-3;
 VrZ:=random(6)-3;


 Vbox:= SMesh_GetBox(Model);
 //   
 Speed:=0.1+random(5)/50;
 end;

 Procedure TAsteroid.Process;
 begin
 inherited;
 y:=y-speed;

 //     
 rot_x:=rot_x+vrx;
 rot_z:=rot_z+vrz;

 //    (),  .
 if y<0 then
 if Frustum_BoxIn( @frust, x, y,z, vbox.x, vbox.y,vbox.z)=false then kill:=true;
 end;

procedure TAsteroid.Draw;
Begin
inherited;
End;

end.
